package ppbot;


import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

/** is an interface for genetic algorithm */
interface GeneticIndividual extends Cloneable, Serializable
{
    public void setElite(boolean b);
    
    public boolean isElite();

    void initializeRandomly();
    
    double getFitness();
    
    void mutate(double mutRate);       
        
    public void crossover(GeneticIndividual indi);

    GeneticIndividual clone(); 
    
    public void serialize(ObjectOutputStream oos) throws IOException;
    
    public void deserialize(ObjectInputStream ois) throws IOException, ClassNotFoundException;    
}